/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Locale;

public class NetworkUtils {
    public static final int NETWORK_NONE = 0;
    public static final int NETWORK_WIFI = 1;
    public static final int NETWORK_2G = 2;
    public static final int NETWORK_3G = 3;
    public static final int NETWORK_4G = 4;
    public static final int NETWORK_MOBILE = 5;
    public static final int NETWORK_ETHERNET = 6;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAvailableByPing(String ip) {
        if (ip == null || ip.length() <= 0) {
            return false;
        }
        Runtime runtime = Runtime.getRuntime();
        Process ipProcess = null;
        try {
            ipProcess = runtime.exec("ping -c 2 -w 2 " + ip);
            int exitValue = ipProcess.waitFor();
            boolean bl = exitValue == 0;
            return bl;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            if (ipProcess != null) {
                ipProcess.destroy();
            }
            runtime.gc();
        }
        return false;
    }

    public boolean isNetWorkConnected(Context context) {
        boolean isConnected = false;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeInfo = cm.getActiveNetworkInfo();
        if (activeInfo != null && activeInfo.isAvailable() && activeInfo.isConnected()) {
            isConnected = true;
        }
        return isConnected;
    }

    public static boolean getIP(String ip, byte[] dst) {
        if (ip == null || ip.isEmpty() || dst.length < 4) {
            return false;
        }
        try {
            String[] split = ip.split("\\.");
            if (split.length != 4) {
                return false;
            }
            byte ip1 = (byte)Integer.parseInt(split[0]);
            byte ip2 = (byte)Integer.parseInt(split[1]);
            byte ip3 = (byte)Integer.parseInt(split[2]);
            byte ip4 = (byte)Integer.parseInt(split[3]);
            if (ip1 <= 255 && ip2 <= 255 && ip3 <= 255 && ip4 <= 255) {
                dst[0] = ip1;
                dst[1] = ip2;
                dst[2] = ip3;
                dst[3] = ip4;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean getMac(String mac, byte[] dst) {
        int i;
        if (mac == null || mac.isEmpty() || dst.length < 6) {
            return false;
        }
        String[] split = mac.split("-");
        if (split.length != 6) {
            return false;
        }
        int[] tmp = new int[6];
        for (i = 0; i < 6; ++i) {
            try {
                tmp[i] = Integer.valueOf(split[i], 16);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (tmp[0] <= 255 && tmp[1] <= 255 && tmp[2] <= 255 && tmp[3] <= 255 & tmp[4] <= 255 && tmp[5] <= 255) {
            for (i = 0; i < 6; ++i) {
                dst[i] = (byte)tmp[i];
            }
            return true;
        }
        return false;
    }

    public static boolean getNetmask(String netmask, byte[] dst) {
        if (netmask == null || netmask.isEmpty() || dst.length < 4) {
            return false;
        }
        try {
            String[] split = netmask.split("\\.");
            if (split.length != 4) {
                return false;
            }
            byte ip1 = (byte)Integer.parseInt(split[0]);
            byte ip2 = (byte)Integer.parseInt(split[1]);
            byte ip3 = (byte)Integer.parseInt(split[2]);
            byte ip4 = (byte)Integer.parseInt(split[3]);
            if (ip1 <= 255 && ip2 <= 255 && ip3 <= 255 && ip4 <= 255) {
                dst[0] = ip1;
                dst[1] = ip2;
                dst[2] = ip3;
                dst[3] = ip4;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean getGateway(String gateway, byte[] dst) {
        if (gateway == null || gateway.isEmpty() || dst.length < 4) {
            return false;
        }
        try {
            String[] split = gateway.split("\\.");
            if (split.length != 4) {
                return false;
            }
            byte ip1 = (byte)Integer.parseInt(split[0]);
            byte ip2 = (byte)Integer.parseInt(split[1]);
            byte ip3 = (byte)Integer.parseInt(split[2]);
            byte ip4 = (byte)Integer.parseInt(split[3]);
            if (ip1 <= 255 && ip2 <= 255 && ip3 <= 255 && ip4 <= 255) {
                dst[0] = ip1;
                dst[1] = ip2;
                dst[2] = ip3;
                dst[3] = ip4;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getConnNetworkType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable()) {
            return networkInfo.getTypeName();
        }
        return "\u65e0\u7f51\u7edc";
    }

    public static int getNetworkState(Context context) {
        NetworkInfo.State state;
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (null == connManager) {
            return 0;
        }
        NetworkInfo activeNetInfo = connManager.getActiveNetworkInfo();
        if (activeNetInfo == null || !activeNetInfo.isAvailable()) {
            return 0;
        }
        if (activeNetInfo != null && activeNetInfo.isAvailable() && activeNetInfo.getTypeName().equals("Ethernet")) {
            return 6;
        }
        NetworkInfo wifiInfo = connManager.getNetworkInfo(1);
        if (null != wifiInfo && null != (state = wifiInfo.getState()) && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            return 1;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        int networkType = telephonyManager.getNetworkType();
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 2;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 3;
            }
            case 13: {
                return 4;
            }
        }
        return 5;
    }

    public static synchronized boolean isWifiConnected(Context context) {
        try {
            int networkInfoType;
            NetworkInfo networkInfo;
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null && ((networkInfoType = networkInfo.getType()) == 1 || networkInfoType == 9)) {
                return networkInfo.isConnected();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isOpenNetwork(Context ctx) {
        ConnectivityManager connManager = (ConnectivityManager)ctx.getSystemService("connectivity");
        if (connManager != null && connManager.getActiveNetworkInfo() != null) {
            return connManager.getActiveNetworkInfo().isAvailable();
        }
        return false;
    }

    public static String getWifiSsid(Context context) {
        String ssid = "unknown id";
        if (Build.VERSION.SDK_INT <= 26 || Build.VERSION.SDK_INT >= 28) {
            WifiManager mWifiManager = (WifiManager)context.getSystemService("wifi");
            assert (mWifiManager != null);
            WifiInfo info = mWifiManager.getConnectionInfo();
            if (Build.VERSION.SDK_INT < 19) {
                return info.getSSID();
            }
            return info.getSSID().replace("\"", "");
        }
        if (Build.VERSION.SDK_INT == 27) {
            ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
            assert (connManager != null);
            NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
            if (networkInfo.isConnected() && networkInfo.getExtraInfo() != null) {
                return networkInfo.getExtraInfo().replace("\"", "");
            }
        }
        return ssid;
    }

    public static String getWifiIp(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        return NetworkUtils.intToIp(wifiInfo.getIpAddress());
    }

    public static String getWifiMac(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        return wifiInfo.getMacAddress();
    }

    public static String getWifiNetmask(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
        return NetworkUtils.intToIp(dhcpInfo.netmask);
    }

    public static String getWifiGateway(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
        return NetworkUtils.intToIp(dhcpInfo.gateway);
    }

    private static String intToIp(int paramInt) {
        return (paramInt & 0xFF) + "." + (0xFF & paramInt >> 8) + "." + (0xFF & paramInt >> 16) + "." + (0xFF & paramInt >> 24);
    }

    public static boolean ipReachable(String ip) {
        try {
            return Inet4Address.getByName(ip).isReachable(200);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String ipToString(int ip) {
        return String.format(Locale.US, "%d.%d.%d.%d", ip & 0xFF, ip >> 8 & 0xFF, ip >> 16 & 0xFF, ip >> 24 & 0xFF);
    }

    public static String getLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ipAddress;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ipAddress = inetAddress.getHostAddress().toString()).contains("::")) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (SocketException ex) {
            Log.e((String)"ERR", (String)ex.toString());
        }
        return "GetHostIP Fail,Please clear the shareReference";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEthernetGateway() {
        Process cmdProcess = null;
        BufferedReader reader = null;
        String dnsIP = "";
        try {
            cmdProcess = Runtime.getRuntime().exec("getprop dhcp.eth0.gateway");
            reader = new BufferedReader(new InputStreamReader(cmdProcess.getInputStream()));
            String string = dnsIP = reader.readLine();
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            cmdProcess.destroy();
        }
    }
}

